import type { ServerDefinition, ServerSource } from './config.js';
export type CliArtifactKind = 'template' | 'bundle' | 'binary';
export interface SerializedServerDefinition {
    readonly name: string;
    readonly description?: string;
    readonly command: {
        kind: 'http';
        url: string;
        headers?: Record<string, string>;
    } | {
        kind: 'stdio';
        command: string;
        args: string[];
        cwd: string;
    };
    readonly env?: Record<string, string>;
    readonly auth?: string;
    readonly tokenCacheDir?: string;
    readonly clientName?: string;
    readonly oauthRedirectUrl?: string;
}
export interface CliArtifactMetadata {
    readonly schemaVersion: 1;
    readonly generatedAt: string;
    readonly generator: {
        readonly name: string;
        readonly version: string;
    };
    readonly server: {
        readonly name: string;
        readonly source?: ServerSource;
        readonly definition: SerializedServerDefinition;
    };
    readonly artifact: {
        readonly path: string;
        readonly kind: CliArtifactKind;
    };
    readonly invocation: {
        serverRef?: string;
        configPath?: string;
        rootDir?: string;
        runtime: 'node' | 'bun';
        bundler?: 'rolldown' | 'bun';
        outputPath?: string;
        bundle?: boolean | string;
        compile?: boolean | string;
        timeoutMs: number;
        minify: boolean;
    };
}
export declare function metadataPathForArtifact(artifactPath: string): string;
export declare function readCliMetadata(artifactPath: string): Promise<CliArtifactMetadata>;
export declare function serializeDefinition(definition: ServerDefinition): SerializedServerDefinition;
//# sourceMappingURL=cli-metadata.d.ts.map