import fs from 'node:fs/promises';
import { parse as parseJsonWithComments, printParseErrorCode } from 'jsonc-parser';
export async function fileExists(filePath) {
    try {
        await fs.access(filePath);
        return true;
    }
    catch {
        return false;
    }
}
export function parseJsonBuffer(buffer) {
    const errors = [];
    const parsed = parseJsonWithComments(buffer, errors, { allowTrailingComma: true });
    const first = errors[0];
    if (first) {
        const message = printParseErrorCode(first.error);
        throw new SyntaxError(`Failed to parse JSON (offset ${first.offset}): ${message}`);
    }
    return parsed;
}
export function isRecord(value) {
    return Boolean(value && typeof value === 'object' && !Array.isArray(value));
}
//# sourceMappingURL=shared.js.map