import { createCallResult } from './result-utils.js';
import type { CallOptions, ListToolsOptions, Runtime, ServerToolInfo } from './runtime.js';
type ToolCallOptions = CallOptions & {
    args?: unknown;
};
type ServerProxy = {
    call(toolName: string, options?: ToolCallOptions): Promise<ReturnType<typeof createCallResult>>;
    listTools(options?: ListToolsOptions): Promise<ServerToolInfo[]>;
};
export interface ServerProxyOptions {
    readonly mapPropertyToTool?: (property: string | symbol) => string;
    readonly cacheSchemas?: boolean;
    readonly initialSchemas?: Record<string, unknown>;
}
export declare function createServerProxy(runtime: Runtime, serverName: string, mapOrOptions?: ((property: string | symbol) => string) | ServerProxyOptions, maybeOptions?: ServerProxyOptions): ServerProxy;
export {};
//# sourceMappingURL=server-proxy.d.ts.map