import type { CliArtifactMetadata } from '../../cli-metadata.js';
import { type ServerDefinition } from '../../config.js';
import type { ServerToolInfo } from '../../runtime.js';
export interface ResolvedServer {
    definition: ServerDefinition;
    name: string;
}
type DefinitionInput = ServerDefinition | (Record<string, unknown> & {
    name: string;
    command?: unknown;
    args?: unknown;
});
export declare function fileExists(filePath: string): Promise<boolean>;
export declare function ensureInvocationDefaults(invocation: CliArtifactMetadata['invocation'], definition: ServerDefinition): CliArtifactMetadata['invocation'];
export declare function resolveServerDefinition(serverRef: string, configPath?: string, rootDir?: string): Promise<ResolvedServer>;
export declare function fetchTools(definition: ServerDefinition, serverName: string, configPath?: string, rootDir?: string): Promise<{
    tools: ServerToolInfo[];
    derivedDescription?: string;
}>;
export declare function normalizeDefinition(def: DefinitionInput): ServerDefinition;
export {};
//# sourceMappingURL=definition.d.ts.map