import type { CliArtifactMetadata, SerializedServerDefinition } from '../../cli-metadata.js';
import type { GenerateCliOptions } from '../../generate-cli.js';
export type InspectableInvocation = CliArtifactMetadata['invocation'] & {
    serverRef?: string;
};
export interface GenerateCliContext {
    invocation: InspectableInvocation;
    definition: SerializedServerDefinition;
}
export declare function buildGenerateCliCommand(invocation: InspectableInvocation, definition: SerializedServerDefinition, globalFlags?: Record<string, string | undefined>): string;
export declare function resolveGenerateRequestFromArtifact(parsed: {
    from?: string;
    server?: string;
    output?: string;
    runtime?: GenerateCliOptions['runtime'];
    bundler?: GenerateCliOptions['bundler'];
    bundle?: GenerateCliOptions['bundle'];
    timeout: number;
    compile?: GenerateCliOptions['compile'];
    minify?: boolean;
}, metadata: CliArtifactMetadata, globalFlags: Record<string, string | undefined>): GenerateCliOptions;
export declare function shellQuote(value: string): string;
//# sourceMappingURL=template-data.d.ts.map