import { looksLikeHttpUrl, normalizeHttpUrlCandidate } from '../http-utils.js';
export function buildInlineServerDefinition(name, command, description) {
    if (typeof command === 'string') {
        const url = normalizeHttpUrlCandidate(command) ?? command;
        if (looksLikeHttpUrl(command)) {
            return {
                name,
                description,
                command: url,
            };
        }
        return {
            name,
            description,
            command: {
                kind: 'http',
                url: new URL(url),
            },
            source: { kind: 'local', path: '<adhoc>' },
        };
    }
    return {
        name,
        description,
        command: {
            kind: 'stdio',
            command: command.command,
            args: command.args ?? [],
        },
        source: { kind: 'local', path: '<adhoc>' },
    };
}
//# sourceMappingURL=server-utils.js.map