export function buildConnectionIssueEnvelope(params) {
    return {
        server: params.server,
        tool: params.tool,
        error: formatErrorMessage(params.error),
        issue: serializeConnectionIssue(params.issue),
    };
}
export function serializeConnectionIssue(issue) {
    if (!issue) {
        return undefined;
    }
    return {
        kind: issue.kind,
        statusCode: issue.statusCode,
        stdioExitCode: issue.stdioExitCode,
        stdioSignal: issue.stdioSignal,
        rawMessage: issue.rawMessage,
    };
}
export function formatErrorMessage(error) {
    if (error instanceof Error) {
        return error.message ?? 'Unknown error';
    }
    if (typeof error === 'string') {
        return error;
    }
    if (error === undefined || error === null) {
        return 'Unknown error';
    }
    try {
        return JSON.stringify(error);
    }
    catch {
        return 'Unknown error';
    }
}
//# sourceMappingURL=json-output.js.map