import { z } from 'zod';
export const ImportKindSchema = z.enum([
    'cursor',
    'claude-code',
    'claude-desktop',
    'codex',
    'windsurf',
    'opencode',
    'vscode',
]);
export const DEFAULT_IMPORTS = [
    'cursor',
    'claude-code',
    'claude-desktop',
    'codex',
    'windsurf',
    'opencode',
    'vscode',
];
const RawLifecycleSchema = z.union([
    z.literal('keep-alive'),
    z.literal('ephemeral'),
    z.object({
        mode: z.union([z.literal('keep-alive'), z.literal('ephemeral')]),
        idleTimeoutMs: z.number().int().positive().optional(),
    }),
]);
const RawLoggingSchema = z
    .object({
    daemon: z
        .object({
        enabled: z.boolean().optional(),
    })
        .optional(),
})
    .optional();
export const RawEntrySchema = z.object({
    description: z.string().optional(),
    baseUrl: z.string().optional(),
    base_url: z.string().optional(),
    url: z.string().optional(),
    serverUrl: z.string().optional(),
    server_url: z.string().optional(),
    command: z.union([z.string(), z.array(z.string())]).optional(),
    executable: z.string().optional(),
    args: z.array(z.string()).optional(),
    headers: z.record(z.string()).optional(),
    env: z.record(z.string()).optional(),
    auth: z.string().optional(),
    tokenCacheDir: z.string().optional(),
    token_cache_dir: z.string().optional(),
    clientName: z.string().optional(),
    client_name: z.string().optional(),
    oauthRedirectUrl: z.string().optional(),
    oauth_redirect_url: z.string().optional(),
    bearerToken: z.string().optional(),
    bearer_token: z.string().optional(),
    bearerTokenEnv: z.string().optional(),
    bearer_token_env: z.string().optional(),
    lifecycle: RawLifecycleSchema.optional(),
    logging: RawLoggingSchema,
});
export const RawConfigSchema = z.object({
    mcpServers: z.record(RawEntrySchema),
    imports: z.array(ImportKindSchema).optional(),
});
//# sourceMappingURL=config-schema.js.map