import { loadServerDefinitions } from '../../config.js';
import { clearOAuthCaches } from '../../oauth-persistence.js';
import { CliUsageError } from '../errors.js';
import { resolveServerDefinition } from './shared.js';
export async function handleLoginCommand(options, args) {
    if (args.length === 0) {
        throw new CliUsageError('Usage: mcporter config login <name|url>');
    }
    await options.invokeAuth([...args]);
}
export async function handleLogoutCommand(options, args) {
    const name = args.shift();
    if (!name) {
        throw new CliUsageError('Usage: mcporter config logout <name>');
    }
    const servers = await loadServerDefinitions(options.loadOptions);
    const target = resolveServerDefinition(name, servers);
    await clearOAuthCaches(target);
    console.log(`Cleared cached credentials for '${target.name}'`);
}
//# sourceMappingURL=auth.js.map