import { z } from 'zod';
export declare const ImportKindSchema: z.ZodEnum<{
    cursor: "cursor";
    "claude-code": "claude-code";
    "claude-desktop": "claude-desktop";
    codex: "codex";
    windsurf: "windsurf";
    opencode: "opencode";
    vscode: "vscode";
}>;
export type ImportKind = z.infer<typeof ImportKindSchema>;
export declare const DEFAULT_IMPORTS: ImportKind[];
declare const RawLifecycleSchema: z.ZodUnion<readonly [z.ZodLiteral<"keep-alive">, z.ZodLiteral<"ephemeral">, z.ZodObject<{
    mode: z.ZodUnion<readonly [z.ZodLiteral<"keep-alive">, z.ZodLiteral<"ephemeral">]>;
    idleTimeoutMs: z.ZodOptional<z.ZodNumber>;
}, z.core.$strip>]>;
export type RawLifecycle = z.infer<typeof RawLifecycleSchema>;
export declare const RawEntrySchema: z.ZodObject<{
    description: z.ZodOptional<z.ZodString>;
    baseUrl: z.ZodOptional<z.ZodString>;
    base_url: z.ZodOptional<z.ZodString>;
    url: z.ZodOptional<z.ZodString>;
    serverUrl: z.ZodOptional<z.ZodString>;
    server_url: z.ZodOptional<z.ZodString>;
    command: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodArray<z.ZodString>]>>;
    executable: z.ZodOptional<z.ZodString>;
    args: z.ZodOptional<z.ZodArray<z.ZodString>>;
    headers: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
    env: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
    auth: z.ZodOptional<z.ZodString>;
    tokenCacheDir: z.ZodOptional<z.ZodString>;
    token_cache_dir: z.ZodOptional<z.ZodString>;
    clientName: z.ZodOptional<z.ZodString>;
    client_name: z.ZodOptional<z.ZodString>;
    oauthRedirectUrl: z.ZodOptional<z.ZodString>;
    oauth_redirect_url: z.ZodOptional<z.ZodString>;
    oauthCommand: z.ZodOptional<z.ZodObject<{
        args: z.ZodArray<z.ZodString>;
    }, z.core.$strip>>;
    oauth_command: z.ZodOptional<z.ZodObject<{
        args: z.ZodArray<z.ZodString>;
    }, z.core.$strip>>;
    bearerToken: z.ZodOptional<z.ZodString>;
    bearer_token: z.ZodOptional<z.ZodString>;
    bearerTokenEnv: z.ZodOptional<z.ZodString>;
    bearer_token_env: z.ZodOptional<z.ZodString>;
    lifecycle: z.ZodOptional<z.ZodUnion<readonly [z.ZodLiteral<"keep-alive">, z.ZodLiteral<"ephemeral">, z.ZodObject<{
        mode: z.ZodUnion<readonly [z.ZodLiteral<"keep-alive">, z.ZodLiteral<"ephemeral">]>;
        idleTimeoutMs: z.ZodOptional<z.ZodNumber>;
    }, z.core.$strip>]>>;
    logging: z.ZodOptional<z.ZodObject<{
        daemon: z.ZodOptional<z.ZodObject<{
            enabled: z.ZodOptional<z.ZodBoolean>;
        }, z.core.$strip>>;
    }, z.core.$strip>>;
}, z.core.$strip>;
export declare const RawConfigSchema: z.ZodObject<{
    mcpServers: z.ZodRecord<z.ZodString, z.ZodObject<{
        description: z.ZodOptional<z.ZodString>;
        baseUrl: z.ZodOptional<z.ZodString>;
        base_url: z.ZodOptional<z.ZodString>;
        url: z.ZodOptional<z.ZodString>;
        serverUrl: z.ZodOptional<z.ZodString>;
        server_url: z.ZodOptional<z.ZodString>;
        command: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodArray<z.ZodString>]>>;
        executable: z.ZodOptional<z.ZodString>;
        args: z.ZodOptional<z.ZodArray<z.ZodString>>;
        headers: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
        env: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
        auth: z.ZodOptional<z.ZodString>;
        tokenCacheDir: z.ZodOptional<z.ZodString>;
        token_cache_dir: z.ZodOptional<z.ZodString>;
        clientName: z.ZodOptional<z.ZodString>;
        client_name: z.ZodOptional<z.ZodString>;
        oauthRedirectUrl: z.ZodOptional<z.ZodString>;
        oauth_redirect_url: z.ZodOptional<z.ZodString>;
        oauthCommand: z.ZodOptional<z.ZodObject<{
            args: z.ZodArray<z.ZodString>;
        }, z.core.$strip>>;
        oauth_command: z.ZodOptional<z.ZodObject<{
            args: z.ZodArray<z.ZodString>;
        }, z.core.$strip>>;
        bearerToken: z.ZodOptional<z.ZodString>;
        bearer_token: z.ZodOptional<z.ZodString>;
        bearerTokenEnv: z.ZodOptional<z.ZodString>;
        bearer_token_env: z.ZodOptional<z.ZodString>;
        lifecycle: z.ZodOptional<z.ZodUnion<readonly [z.ZodLiteral<"keep-alive">, z.ZodLiteral<"ephemeral">, z.ZodObject<{
            mode: z.ZodUnion<readonly [z.ZodLiteral<"keep-alive">, z.ZodLiteral<"ephemeral">]>;
            idleTimeoutMs: z.ZodOptional<z.ZodNumber>;
        }, z.core.$strip>]>>;
        logging: z.ZodOptional<z.ZodObject<{
            daemon: z.ZodOptional<z.ZodObject<{
                enabled: z.ZodOptional<z.ZodBoolean>;
            }, z.core.$strip>>;
        }, z.core.$strip>>;
    }, z.core.$strip>>;
    imports: z.ZodOptional<z.ZodArray<z.ZodEnum<{
        cursor: "cursor";
        "claude-code": "claude-code";
        "claude-desktop": "claude-desktop";
        codex: "codex";
        windsurf: "windsurf";
        opencode: "opencode";
        vscode: "vscode";
    }>>>;
}, z.core.$strip>;
export type RawEntry = z.infer<typeof RawEntrySchema>;
export type RawConfig = z.infer<typeof RawConfigSchema>;
export interface HttpCommand {
    readonly kind: 'http';
    readonly url: URL;
    readonly headers?: Record<string, string>;
}
export interface StdioCommand {
    readonly kind: 'stdio';
    readonly command: string;
    readonly args: string[];
    readonly cwd: string;
}
export type CommandSpec = HttpCommand | StdioCommand;
export interface ServerSource {
    readonly kind: 'local' | 'import';
    readonly path: string;
    readonly importKind?: ImportKind;
}
export type ServerLifecycle = {
    mode: 'keep-alive';
    idleTimeoutMs?: number;
} | {
    mode: 'ephemeral';
};
export interface ServerLoggingOptions {
    readonly daemon?: {
        readonly enabled?: boolean;
    };
}
export interface ServerDefinition {
    readonly name: string;
    readonly description?: string;
    readonly command: CommandSpec;
    readonly env?: Record<string, string>;
    readonly auth?: string;
    readonly tokenCacheDir?: string;
    readonly clientName?: string;
    readonly oauthRedirectUrl?: string;
    readonly oauthCommand?: {
        readonly args: string[];
    };
    readonly source?: ServerSource;
    readonly sources?: readonly ServerSource[];
    readonly lifecycle?: ServerLifecycle;
    readonly logging?: ServerLoggingOptions;
}
export interface LoadConfigOptions {
    readonly configPath?: string;
    readonly rootDir?: string;
}
export {};
//# sourceMappingURL=config-schema.d.ts.map