import type { OAuthClientInformationMixed, OAuthTokens } from '@modelcontextprotocol/sdk/shared/auth.js';
import type { ServerDefinition } from './config.js';
import type { Logger } from './logging.js';
export type OAuthClearScope = 'all' | 'client' | 'tokens' | 'verifier' | 'state';
export interface OAuthPersistence {
    describe(): string;
    readTokens(): Promise<OAuthTokens | undefined>;
    saveTokens(tokens: OAuthTokens): Promise<void>;
    readClientInfo(): Promise<OAuthClientInformationMixed | undefined>;
    saveClientInfo(info: OAuthClientInformationMixed): Promise<void>;
    readCodeVerifier(): Promise<string | undefined>;
    saveCodeVerifier(value: string): Promise<void>;
    readState(): Promise<string | undefined>;
    saveState(value: string): Promise<void>;
    clear(scope: OAuthClearScope): Promise<void>;
}
export declare function buildOAuthPersistence(definition: ServerDefinition, logger?: Logger): Promise<OAuthPersistence>;
export declare function clearOAuthCaches(definition: ServerDefinition, logger?: Logger, scope?: OAuthClearScope): Promise<void>;
export declare function readCachedAccessToken(definition: ServerDefinition, logger?: Logger): Promise<string | undefined>;
//# sourceMappingURL=oauth-persistence.d.ts.map