import type { OAuthClientInformationMixed, OAuthTokens } from '@modelcontextprotocol/sdk/shared/auth.js';
import type { ServerDefinition } from './config.js';
type VaultKey = string;
export interface VaultEntry {
    serverName: string;
    serverUrl?: string;
    tokens?: OAuthTokens;
    clientInfo?: OAuthClientInformationMixed;
    codeVerifier?: string;
    state?: string;
    updatedAt: string;
}
export declare function vaultKeyForDefinition(definition: ServerDefinition): VaultKey;
export declare function loadVaultEntry(definition: ServerDefinition): Promise<VaultEntry | undefined>;
export declare function saveVaultEntry(definition: ServerDefinition, patch: Partial<VaultEntry>): Promise<void>;
export declare function clearVaultEntry(definition: ServerDefinition, scope: 'all' | 'tokens' | 'client' | 'verifier' | 'state'): Promise<void>;
export {};
//# sourceMappingURL=oauth-vault.d.ts.map