import { Client } from '@modelcontextprotocol/sdk/client/index.js';
import type { Transport } from '@modelcontextprotocol/sdk/shared/transport.js';
import type { ServerDefinition } from '../config.js';
import type { Logger } from '../logging.js';
import { type OAuthSession } from '../oauth.js';
export interface ClientContext {
    readonly client: Client;
    readonly transport: Transport & {
        close(): Promise<void>;
    };
    readonly definition: ServerDefinition;
    readonly oauthSession?: OAuthSession;
}
export interface CreateClientContextOptions {
    readonly maxOAuthAttempts?: number;
    readonly oauthTimeoutMs?: number;
    readonly onDefinitionPromoted?: (definition: ServerDefinition) => void;
    readonly allowCachedAuth?: boolean;
}
export declare function createClientContext(definition: ServerDefinition, logger: Logger, clientInfo: {
    name: string;
    version: string;
}, options?: CreateClientContextOptions): Promise<ClientContext>;
//# sourceMappingURL=transport.d.ts.map