import type { GeneratedOption } from './generate/tools.js';
import type { FlagUsageExtra } from './list-signature.js';
export type { FlagUsageExtra } from './list-signature.js';
export { formatCallExpressionExample, formatExampleBlock, formatFlagLabel, formatFlagUsage, formatFunctionSignature, formatOptionalSummary, } from './list-signature.js';
export interface SelectDisplayOptionsResult {
    displayOptions: GeneratedOption[];
    hiddenOptions: GeneratedOption[];
}
export interface ToolDocInput {
    serverName: string;
    toolName: string;
    description?: string;
    outputSchema?: unknown;
    options: GeneratedOption[];
    requiredOnly: boolean;
    colorize?: boolean;
    exampleMaxLength?: number;
    flagExtras?: FlagUsageExtra[];
    defaultReturnType?: string;
    callSelector?: string;
    wrapExampleExpression?: boolean;
}
export interface ToolDocModel {
    docLines?: string[];
    signature: string;
    tsSignature: string;
    flagUsage: string;
    optionalSummary?: string;
    examples: string[];
    displayOptions: GeneratedOption[];
    hiddenOptions: GeneratedOption[];
    optionDocs: ToolOptionDoc[];
}
export interface ToolOptionDoc {
    option: GeneratedOption;
    flagLabel: string;
    description: string;
}
export declare function selectDisplayOptions(options: GeneratedOption[], requiredOnly: boolean, minVisible?: number): SelectDisplayOptionsResult;
export declare function buildToolDoc(input: ToolDocInput): ToolDocModel;
//# sourceMappingURL=list-detail-helpers.d.ts.map