import type { ServerDefinition } from '../config.js';
export interface EphemeralServerSpec {
    name?: string;
    httpUrl?: string;
    allowInsecureHttp?: boolean;
    stdioCommand?: string;
    stdioArgs?: string[];
    cwd?: string;
    env?: Record<string, string>;
    description?: string;
    persistPath?: string;
}
export interface EphemeralServerResolution {
    definition: ServerDefinition;
    name: string;
    persistedEntry: Record<string, unknown>;
}
export declare function resolveEphemeralServer(spec: EphemeralServerSpec): EphemeralServerResolution;
export declare function persistEphemeralServer(resolution: EphemeralServerResolution, rawPath: string): Promise<void>;
export declare function splitCommandLine(input: string): string[];
//# sourceMappingURL=adhoc-server.d.ts.map